       program residualdetrend
c
       parameter (nmax=2000)
       real pc1(nmax)
       real newpc1(nmax), offset(nmax)
c
c      regress out co2-correlated trend (r=0.9 w/ co2)
c      after 1800 from pc1 of ITRDB data
c
       open (unit=3,file='pc1-rescaled.dat',status='old')
       open (unit=7,file='pc1-fixed.dat',status='unknown')
       do i=1,nmax
          read (3,*,end=99) iyear,pc1(iyear)
       end do
99     nx = i-1
c
c      linear segments describing approximate residuals
c      relative to fit withrespect to secular trend
c
       do i=1,1699
          offset(i)=0.0
       end do
       do i=1700,1750
          offset(i)=0.0+float(i-1700)*(0.007-0.0)/50.0
       end do
       do i=1751,1800
          offset(i)=0.007+float(i-1750)*(0.09-0.007)/50.0
       end do
       do i=1800,1850
          offset(i)=0.09+float(i-1800)*(0.23-0.09)/50.0
       end do
       do i=1851,1875
          offset(i)=0.23+float(i-1850)*(0.29-0.23)/25.0
       end do
       do i=1876,1900
          offset(i)=0.29+float(i-1875)*(0.31-0.29)/25.0
       end do
       do i=1901,1980
          offset(i)=0.31+float(i-1900)*(0.27-0.31)/80.0
       end do
c
c      remove co2-correlated portion 
c      pc1 series
c
       do i=1000,1980
          newpc1(i)=pc1(i)-offset(i)
          write (7,77) i,newpc1(i),pc1(i),offset(i)
       end do
77     format (i6,3f14.6)     
       close (unit=3)
       close (unit=7)
       stop
       end
