       program co2detrend
c
       parameter (nmax=2000)
       real pc1(nmax),co2(nmax)
       real standard1(nmax),standard2(nmax)
       real newpc1(nmax)
c
c      regress out co2-correlated trend (r=0.9 w/ co2)
c      after 1800 from pc1 of ITRDB data
c
       open (unit=3,file='pc01.out',status='old')
       open (unit=4,file='ghg-lowf.dat',status='old')
       open (unit=7,file='pc01-fixed.dat',status='unknown')
       do i=1,nmax
          read (3,*,end=99) iyear,pc1(iyear)
       end do
99     nx = i-1
       do i=1,nmax
          read (4,*,end=199) adum,val2
          idum = float(1610+adum)
          co2(idum)=val2
       end do
199    nx2 = i-1
c
c      standardize series based on 1800-1980 mean and variance
c
       asum1 = 0.0
       asum2 = 0.0
       var1 = 0.0
       var2 = 0.0
c
       nn = 1980-1800+1
       do i=1800,1980
          asum1 = asum1+pc1(i)
          asum2 = asum2+co2(i)
       end do
       asum1 = asum1/float(nn)
       asum2 = asum2/float(nn)
       do i=1000,1980
          standard1(i)=pc1(i)-asum1
       end do
       do i=1610,1980
          standard2(i)=co2(i)-asum2
       end do
       do i=1800,1980
          var1 = var1+standard1(i)**2
          var2 = var2+standard2(i)**2
       end do
       sd1 = sqrt(var1/float(nn))
       sd2 = sqrt(var2/float(nn))
       do i=1000,1980
          standard1(i)=standard1(i)/sd1
       end do
       do i=1610,1980
          standard2(i)=standard2(i)/sd2
       end do
c
c      remove co2-correlated portion (r=0.9) of 1800-1980
c 
       corr= 0.9
c
c      pc1 series
c
       do i=1000
       do i=1000,1980
          newpc1(i)=sd1*(standard1(i)-corr*standard2(i))+asum1
          write (7,77) i,newpc1(i),pc1(i)
       end do
77     format (i6,2f14.6)     
       close (unit=3)
       close (unit=4)
       close (unit=7)
       stop
       end
