pro iterfit,x,y,alow,ahigh,a,rmse=rmse,prec=prec
;
; Fits y = a^x to some data, by iterative methods
; until a is known to within +-0.5prec
;
if keyword_set(prec) eq 0 then prec=0.01
maxits=40
;
yest=alow^x
rmslow=sqrt(total((y-yest)^2)/float(n_elements(x)))
;
yest=ahigh^x
rmshigh=sqrt(total((y-yest)^2)/float(n_elements(x)))
;
i=0
while (ahigh-alow gt prec) and (i lt maxits) do begin
  ;
  i=i+1
  da=(ahigh-alow)/3.
  ;
  a1=alow+da
  yest=a1^x
  rms1=sqrt(total((y-yest)^2)/float(n_elements(x)))
  ;
  a2=alow+2.*da
  yest=a2^x
  rms2=sqrt(total((y-yest)^2)/float(n_elements(x)))
;print,i
;print,alow,rmslow
;print,a1,rms1
;print,a2,rms2
;print,ahigh,rmshigh
  ;
  if rms1 lt rms2 then begin
    ahigh=a2
    rmshigh=rms2
  endif else begin
    alow=a1
    rmslow=rms1
  endelse
  ;
endwhile
;
;print,i,maxits
;print,alow,rmslow
;print,a1,rms1
;print,a2,rms2
;print,ahigh,rmshigh
a=0.5*(a1+a2)
rmse=0.5*(rms1+rms2)
;
end
